#!/usr/bin/env python

import warnings
warnings.simplefilter(action='ignore', category=FutureWarning)

import numpy as np
import pandas as pd
from matplotlib import pyplot as plt
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import LSTM
from tensorflow.keras.layers import Dense, Dropout
from sklearn.preprocessing import MinMaxScaler
from keras.wrappers.scikit_learn import KerasRegressor
from sklearn.model_selection import GridSearchCV
from pandas import read_csv
import math
from sklearn.metrics import mean_squared_error

dataframe = read_csv('data1.csv')
dataframe =dataframe[~dataframe.isin([np.nan, np.inf, -np.inf]).any(1)]
dataset = dataframe.values
df = np.nan_to_num(dataset)

print(df.shape)
print(len(df))

test_split=round(len(df)*0.10)
print(test_split)

train_size = int(len(df) * 0.9)
test_size = len(df) - train_size
df_for_training = df[:-test_split] 
df_for_testing = df[-test_split:]


print(df_for_training.shape)
print(df_for_testing.shape)

scaler = MinMaxScaler(feature_range=(0,1))
df_for_training_scaled = scaler.fit_transform(df_for_training)
df_for_testing_scaled=scaler.transform(df_for_testing)


print(df_for_training_scaled)

def createXY(dataset,n_past):
    dataX = []
    dataY = []
    for i in range(n_past, len(dataset)):
             dataX.append(dataset[i - n_past:i, 0:dataset.shape[1]])
             dataY.append(dataset[i,0])
    return np.array(dataX),np.array(dataY)
    
trainX,trainY=createXY(df_for_training_scaled,10)
testX,testY=createXY(df_for_testing_scaled,10)

print("trainX Shape-- ",trainX.shape)
print("trainY Shape-- ",trainY.shape)

print("testX Shape-- ",testX.shape)
print("testY Shape-- ",testY.shape)

def build_model(optimizer):
    grid_model = Sequential()
    grid_model.add(LSTM(50,return_sequences=True,input_shape=(10,6)))
    grid_model.add(LSTM(50))
    grid_model.add(Dropout(0.2))
    grid_model.add(Dense(1))    
    grid_model.compile(loss = 'mse',optimizer = optimizer) 
    
    
    return grid_model
    
grid_model=KerasRegressor(build_fn=build_model,verbose=1,validation_data=(testX,testY))
        
parameters = {'batch_size' : [20],'epochs' : [10],'optimizer' : ['adam'] }
    
grid_search  = GridSearchCV(estimator = grid_model,param_grid = parameters,cv = 2)

grid_search = grid_search.fit(trainX,trainY)

print(grid_search.best_params_)

my_model=grid_search.best_estimator_.model

prediction=my_model.predict(testX)
print("prediction\n", prediction)
print("\nPrediction Shape-",prediction.shape)

prediction_copies_array = np.repeat(prediction,6, axis=-1)

prediction_copies_array.shape

pred=scaler.inverse_transform(np.reshape(prediction_copies_array,(len(prediction),6)))[:,0]


original_copies_array = np.repeat(testY,6, axis=-1)
original=scaler.inverse_transform(np.reshape(original_copies_array,(len(testY),6)))[:,0]

print("Pred Values-- " ,pred)
print("\nOriginal Values-- " ,original)

# calculate root mean squared error
trainScore = math.sqrt(mean_squared_error(original, pred))
print('Train Score: %.2f RMSE' % (trainScore))

plt.plot(original, color = 'red', label = 'Real RSSI')
plt.plot(pred, color = 'blue', label = 'Predicted RSSI')
plt.title('RSSI over time')
plt.xlabel('Time')
plt.ylabel('RSSI (dbm)')
plt.legend()
plt.show()

 
